/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_5699;

public final class CodecUtil {
    public static <T extends Enum<T>> Codec<T> createEnumCodec(T[] enums) {
        Function<String, Enum> function;
        if (enums.length > 16) {
            Map<String, Enum> map = Arrays.stream(enums).collect(Collectors.toMap(Enum::name, value -> value));
            function = name -> name == null ? null : (Enum)map.get(name);
        } else {
            function = name -> {
                for (Enum constant : enums) {
                    if (!constant.name().equals(name)) continue;
                    return constant;
                }
                return null;
            };
        }
        return new EnumCodec(enums, function);
    }

    public static class EnumCodec<E extends Enum<E>>
    implements Codec<E> {
        private final Codec<E> codec;

        public EnumCodec(E[] values, Function<String, E> idToConstant) {
            this.codec = class_5699.method_39512((Codec)class_5699.method_39508(Enum::name, idToConstant), (Codec)class_5699.method_39511(Enum::ordinal, ordinal -> ordinal >= 0 && ordinal < values.length ? values[ordinal] : null, (int)-1));
        }

        public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
            return this.codec.decode(ops, input);
        }

        public <T> DataResult<T> encode(E stringIdentifiable, DynamicOps<T> dynamicOps, T object) {
            return this.codec.encode(stringIdentifiable, dynamicOps, object);
        }
    }
}

