/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelDataImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1047;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

public class ConnectingModelType
implements ModelType<ConnectingModelData> {
    public static final class_2960 DEFAULT_CONNECTION_KEY = new class_2960("fusion", "default");

    @Override
    public Collection<class_2960> getModelDependencies(ConnectingModelData data) {
        return DefaultModelTypes.VANILLA.getModelDependencies(data.getVanillaModel());
    }

    @Override
    @Nullable
    public class_793 getAsVanillaModel(ConnectingModelData data) {
        return DefaultModelTypes.VANILLA.getAsVanillaModel(data.getVanillaModel());
    }

    @Override
    public class_1087 bake(ModelBakingContext context, ConnectingModelData data) {
        class_1087 model = DefaultModelTypes.VANILLA.bake(context, data.getVanillaModel());
        Map<class_2960, ConnectionPredicate> predicates = data.getAllConnectionPredicates().entrySet().stream().map(entry -> Pair.of(((String)entry.getKey()).equals("default") ? DEFAULT_CONNECTION_KEY : data.getVanillaModel().method_24077((String)entry.getKey()).method_24147(), (ConnectionPredicate)entry.getValue())).filter(pair -> !((class_2960)pair.left()).equals((Object)class_1047.method_4539())).collect(Collectors.toUnmodifiableMap(Pair::left, Pair::right, (xva$0, xva$1) -> DefaultConnectionPredicates.or(xva$0, xva$1)));
        return new ConnectingBakedModel(model, context.getTransformation().method_3509(), predicates);
    }

    @Override
    public ConnectingModelData deserialize(JsonObject json) throws JsonParseException {
        class_793 model = (class_793)DefaultModelTypes.VANILLA.deserialize(json);
        HashMap<String, ConnectionPredicate> predicates = new HashMap<String, ConnectionPredicate>();
        predicates.put("default", DefaultConnectionPredicates.isSameState());
        if (json.has("connections")) {
            JsonElement connectionsElement = json.get("connections");
            if (connectionsElement.isJsonArray() || connectionsElement.isJsonObject() && connectionsElement.getAsJsonObject().has("type")) {
                predicates.put("default", ConnectingModelType.loadPredicate(connectionsElement, "connections"));
            } else if (connectionsElement.isJsonObject()) {
                JsonObject object = connectionsElement.getAsJsonObject();
                if (object.size() == 0) {
                    throw new JsonParseException("Property 'connections' must have a 'type' key or keys per texture!");
                }
                for (String texture : object.keySet()) {
                    predicates.put(texture, ConnectingModelType.loadPredicate(object.get(texture), texture));
                }
            } else {
                throw new JsonParseException("Property 'connections' must be an array!");
            }
        }
        return new ConnectingModelDataImpl(model, predicates);
    }

    @Override
    public JsonObject serialize(ConnectingModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        Map<String, ConnectionPredicate> predicates = value.getAllConnectionPredicates();
        if (predicates.size() == 1 && predicates.containsKey("default")) {
            json.add("connections", (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicates.get("default")));
        } else if (!predicates.isEmpty()) {
            JsonObject connectionsJson = new JsonObject();
            predicates.forEach((texture, predicate) -> connectionsJson.add(texture, (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate)));
            json.add("connections", (JsonElement)connectionsJson);
        }
        return json.size() == 0 ? null : json;
    }

    private static ConnectionPredicate loadPredicate(JsonElement element, String key) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<ConnectionPredicate> subPredicates = new ArrayList<ConnectionPredicate>();
            for (JsonElement predicateElements : array) {
                if (!predicateElements.isJsonObject()) {
                    throw new JsonParseException("Predicate '" + key + "' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(predicateElements.getAsJsonObject());
                subPredicates.add(predicate);
            }
            return DefaultConnectionPredicates.or((ConnectionPredicate[])subPredicates.toArray(ConnectionPredicate[]::new));
        }
        if (element.isJsonObject()) {
            return FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
        }
        throw new JsonParseException("Predicate '" + key + "' must be an object or an array!");
    }
}

