/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.harvester;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class HarvesterActorInstance
extends ActorInstance {
    static float originOffset = 0.0625f;
    static class_243 rotOffset = new class_243(0.5, (double)(-2.0f * originOffset + 0.5f), (double)(originOffset + 0.5f));
    protected ModelData harvester;
    private class_2350 facing;
    protected float horizontalAngle;
    private double rotation;
    private double previousRotation;

    public HarvesterActorInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        Material material = materialManager.defaultCutout().material(Materials.TRANSFORMED);
        class_2680 state = context.state;
        this.facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        this.harvester = (ModelData)material.getModel(this.getRollingPartial(), state).createInstance();
        this.horizontalAngle = this.facing.method_10144() + (float)(this.facing.method_10166() == class_2350.class_2351.field_11048 ? 180 : 0);
        this.harvester.setBlockLight(this.localBlockLight());
    }

    protected PartialModel getRollingPartial() {
        return AllPartialModels.HARVESTER_BLADE;
    }

    protected class_243 getRotationOffset() {
        return rotOffset;
    }

    protected double getRadius() {
        return 6.5;
    }

    @Override
    public void tick() {
        super.tick();
        this.previousRotation = this.rotation;
        if (this.context.contraption.stalled || this.context.disabled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.method_10153())) {
            return;
        }
        double arcLength = this.context.motion.method_1033();
        double radians = arcLength * 16.0 / this.getRadius();
        float deg = AngleHelper.deg(radians);
        deg = (int)(deg * 3000.0f) / 3000;
        this.rotation += (double)deg * 1.25;
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.harvester.loadIdentity().translate((class_2382)this.context.localPos)).centre()).rotateY((double)this.horizontalAngle)).unCentre()).translate(this.getRotationOffset())).rotateX(this.getRotation())).translateBack(this.getRotationOffset());
    }

    protected double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }
}

