/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api;

import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.ClaimUtils;
import draylar.goml.api.DataKey;
import draylar.goml.api.event.ClaimEvents;
import draylar.goml.api.group.PlayerGroup;
import draylar.goml.api.group.PlayerGroupProvider;
import draylar.goml.block.ClaimAnchorBlock;
import draylar.goml.block.entity.ClaimAnchorBlockEntity;
import draylar.goml.cca.ClaimComponent;
import draylar.goml.registry.GOMLAugments;
import draylar.goml.registry.GOMLBlocks;
import draylar.goml.ui.AdminAugmentGui;
import draylar.goml.ui.ClaimAugmentGui;
import draylar.goml.ui.ClaimPlayerListGui;
import draylar.goml.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Claim {
    public static final String POSITION_KEY = "Pos";
    public static final String OWNERS_KEY = "Owners";
    public static final String TRUSTED_KEY = "Trusted";
    public static final String TRUSTED_GROUP_KEY = "TrustedGroups";
    public static final String ICON_KEY = "Icon";
    public static final String TYPE_KEY = "Type";
    public static final String AUGMENTS_KEY = "Augments";
    public static final String CUSTOM_DATA_KEY = "CustomData";
    private static final String BOX_KEY = "Box";
    private final Set<UUID> owners = new HashSet<UUID>();
    private final Set<UUID> trusted = new HashSet<UUID>();
    @Nullable
    private Set<PlayerGroup> trustedGroups;
    private final MinecraftServer server;
    private final Set<PlayerGroup.Key> trustedGroupKeys = new HashSet<PlayerGroup.Key>();
    private final class_2338 origin;
    private ClaimAnchorBlock type = (ClaimAnchorBlock)((Object)GOMLBlocks.MAKESHIFT_CLAIM_ANCHOR.getFirst());
    private class_2960 world;
    @Nullable
    private class_1799 icon;
    private Map<DataKey<Object>, Object> customData = new HashMap<DataKey<Object>, Object>();
    private ClaimBox claimBox;
    private int chunksLoadedCount;
    private final Map<class_2338, Augment> augments = new HashMap<class_2338, Augment>();
    private final List<class_1657> previousTickPlayers = new ArrayList<class_1657>();
    private boolean destroyed = false;

    @ApiStatus.Internal
    public Claim(MinecraftServer server, Set<UUID> owners, Set<UUID> trusted, class_2338 origin) {
        this.server = server;
        this.owners.addAll(owners);
        this.trusted.addAll(trusted);
        this.origin = origin;
    }

    public boolean isOwner(class_1657 player) {
        return this.isOwner(player.method_5667());
    }

    public boolean isOwner(UUID uuid) {
        return this.owners.contains(uuid);
    }

    public void addOwner(class_1657 player) {
        this.owners.add(player.method_5667());
    }

    public void addOwner(UUID id) {
        this.owners.add(id);
    }

    public boolean hasPermission(class_1657 player) {
        return this.hasPermission(player.method_5667());
    }

    public boolean hasPermission(UUID uuid) {
        for (PlayerGroup group : this.getGroups()) {
            if (!group.isPartOf(uuid)) continue;
            return true;
        }
        return this.hasDirectPermission(uuid);
    }

    public boolean hasDirectPermission(UUID uuid) {
        return this.owners.contains(uuid) || this.trusted.contains(uuid);
    }

    public void trust(class_1657 player) {
        this.trusted.add(player.method_5667());
    }

    public void trust(UUID uuid) {
        this.trusted.add(uuid);
    }

    public void trust(PlayerGroup group) {
        this.getGroups().add(group);
        group.addClaim(this);
    }

    public void untrust(class_1657 player) {
        this.trusted.remove(player.method_5667());
    }

    public void untrust(PlayerGroup group) {
        this.getGroups().remove(group);
        group.removeClaim(this);
    }

    public void untrust(UUID uuid) {
        this.trusted.remove(uuid);
    }

    public Set<UUID> getOwners() {
        return this.owners;
    }

    public Set<UUID> getTrusted() {
        return this.trusted;
    }

    public class_2338 getOrigin() {
        return this.origin;
    }

    public class_2487 asNbt() {
        class_2487 nbt = new class_2487();
        class_2499 ownersTag = new class_2499();
        for (UUID uUID : this.owners) {
            ownersTag.add((Object)class_2512.method_25929((UUID)uUID));
        }
        class_2499 trustedTag = new class_2499();
        for (UUID uUID : this.trusted) {
            trustedTag.add((Object)class_2512.method_25929((UUID)uUID));
        }
        class_2499 class_24992 = new class_2499();
        if (this.trustedGroups != null) {
            for (PlayerGroup playerGroup : this.trustedGroups) {
                PlayerGroup.Key id;
                if (!playerGroup.canSave() || (id = playerGroup.getKey()) == null) continue;
                class_24992.add((Object)class_2519.method_23256((String)id.compact()));
            }
        }
        for (PlayerGroup.Key key : this.trustedGroupKeys) {
            class_24992.add((Object)class_2519.method_23256((String)key.compact()));
        }
        nbt.method_10566(OWNERS_KEY, (class_2520)ownersTag);
        nbt.method_10566(TRUSTED_KEY, (class_2520)trustedTag);
        nbt.method_10566(TRUSTED_GROUP_KEY, (class_2520)class_24992);
        nbt.method_10544(POSITION_KEY, this.origin.method_10063());
        if (this.icon != null) {
            nbt.method_10566(ICON_KEY, (class_2520)this.icon.method_7953(new class_2487()));
        }
        nbt.method_10582(TYPE_KEY, class_7923.field_41175.method_10221((Object)this.type).toString());
        class_2487 class_24872 = new class_2487();
        for (Map.Entry<DataKey<Object>, Object> entry : this.customData.entrySet()) {
            class_2520 value = entry.getKey().serializer().apply(entry.getValue());
            if (value == null) continue;
            class_24872.method_10566(entry.getKey().key().toString(), value);
        }
        nbt.method_10566(CUSTOM_DATA_KEY, (class_2520)class_24872);
        class_2499 class_24993 = new class_2499();
        for (Map.Entry<class_2338, Augment> entry : this.augments.entrySet()) {
            class_2487 value = new class_2487();
            value.method_10566(POSITION_KEY, (class_2520)class_2512.method_10692((class_2338)entry.getKey()));
            value.method_10582(TYPE_KEY, GOMLAugments.getId(entry.getValue()).toString());
            class_24993.add((Object)value);
        }
        nbt.method_10566(AUGMENTS_KEY, (class_2520)class_24993);
        nbt.method_10566(BOX_KEY, this.claimBox.toNbt());
        return nbt;
    }

    @ApiStatus.Internal
    public static Claim fromNbt(MinecraftServer server, class_2487 nbt, int version) {
        class_2248 block;
        HashSet<UUID> ownerUUIDs = new HashSet<UUID>();
        for (Object ownerUUID : nbt.method_10554(OWNERS_KEY, 11)) {
            ownerUUIDs.add(class_2512.method_25930((class_2520)ownerUUID));
        }
        HashSet<UUID> trustedUUIDs = new HashSet<UUID>();
        for (Object trustedUUID : nbt.method_10554(TRUSTED_KEY, 11)) {
            trustedUUIDs.add(class_2512.method_25930((class_2520)trustedUUID));
        }
        Claim claim = new Claim(server, ownerUUIDs, trustedUUIDs, class_2338.method_10092((long)nbt.method_10537(POSITION_KEY)));
        for (class_2520 nbtId : nbt.method_10554(OWNERS_KEY, 8)) {
            PlayerGroup group;
            PlayerGroup.Key id = PlayerGroup.Key.of(nbtId.method_10714());
            if (id == null || (group = PlayerGroupProvider.getGroup(server, id)) == null) continue;
            claim.trust(group);
        }
        if (nbt.method_10573(ICON_KEY, 10)) {
            claim.icon = class_1799.method_7915((class_2487)nbt.method_10562(ICON_KEY));
        } else if (nbt.method_10573(ICON_KEY, 10)) {
            claim.icon = class_1799.method_7915((class_2487)nbt.method_10562(ICON_KEY));
        } else if (nbt.method_10573(TYPE_KEY, 8) && (block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)nbt.method_10558(TYPE_KEY)))) instanceof ClaimAnchorBlock) {
            ClaimAnchorBlock anchorBlock;
            claim.type = anchorBlock = (ClaimAnchorBlock)block;
        }
        class_2487 customData = nbt.method_10562(CUSTOM_DATA_KEY);
        for (String stringKey : customData.method_10541()) {
            class_2960 key = class_2960.method_12829((String)stringKey);
            DataKey<?> dataKey = DataKey.getKey(key);
            if (dataKey == null) continue;
            claim.customData.put(dataKey, dataKey.deserializer().apply(customData.method_10580(stringKey)));
        }
        claim.claimBox = version == 0 ? ClaimBox.EMPTY : ClaimBox.readNbt(nbt.method_10562(BOX_KEY), 0);
        for (class_2520 entry : nbt.method_10554(AUGMENTS_KEY, 10)) {
            class_2487 value = (class_2487)entry;
            class_2338 pos = class_2512.method_10691((class_2487)value.method_10562(POSITION_KEY));
            Augment type = GOMLAugments.get(class_2960.method_12829((String)value.method_10558(TYPE_KEY)));
            if (pos == null || type == null) continue;
            claim.augments.put(pos, type);
        }
        for (class_2520 string : nbt.method_10554(TRUSTED_GROUP_KEY, 8)) {
            claim.trustedGroupKeys.add(PlayerGroup.Key.of(string.method_10714()));
        }
        for (Map.Entry<class_2338, Augment> augment : claim.augments.entrySet()) {
            augment.getValue().onLoaded(claim, augment.getKey());
        }
        return claim;
    }

    public class_2960 getWorld() {
        return this.world != null ? this.world : new class_2960("undefined");
    }

    @Nullable
    public class_3218 getWorldInstance(MinecraftServer server) {
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.getWorld()));
    }

    @Deprecated
    @Nullable
    public ClaimAnchorBlockEntity getBlockEntityInstance(MinecraftServer server) {
        class_2586 class_25862 = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.getWorld())).method_8321(this.origin);
        if (class_25862 instanceof ClaimAnchorBlockEntity) {
            ClaimAnchorBlockEntity claimAnchorBlock = (ClaimAnchorBlockEntity)class_25862;
            return claimAnchorBlock;
        }
        return null;
    }

    public class_1799 getIcon() {
        return this.icon != null ? this.icon.method_7972() : class_1802.field_20391.method_7854();
    }

    @Nullable
    public <T> T getData(DataKey<T> key) {
        try {
            Object val = this.customData.get(key);
            if (val == null) {
                val = key.defaultSupplier().get();
                this.customData.put(key, val);
            }
            return (T)val;
        }
        catch (Exception e) {
            return key.defaultValue();
        }
    }

    public <T> void setData(DataKey<T> key, T data) {
        if (data != null) {
            this.customData.put(key, data);
        } else {
            this.customData.remove(key);
        }
    }

    public <T> void removeData(DataKey<T> key) {
        this.setData(key, null);
    }

    public Collection<DataKey<?>> getDataKeys() {
        return Collections.unmodifiableCollection(this.customData.keySet());
    }

    public void openUi(class_3222 player) {
        SimpleGui gui = new SimpleGui(class_3917.field_17337, player, false);
        gui.setTitle((class_2561)class_2561.method_43471((String)"text.goml.gui.claim.title"));
        gui.addSlot((GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)this.icon).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.claim.about")).setLore(ClaimUtils.getClaimText(player.field_13995, this)));
        gui.addSlot((GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.claim.players").method_27692(class_124.field_1068)).setCallback((x, y, z) -> {
            PagedGui.playClickSound(player);
            ClaimPlayerListGui.open(player, this, ClaimUtils.isInAdminMode((class_1657)player), () -> this.openUi(player));
        }));
        gui.addSlot((GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.claim.augments").method_27692(class_124.field_1068)).setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTYzODY5NTA3NjA3MCwKICAicHJvZmlsZUlkIiA6ICJiN2ZkYmU2N2NkMDA0NjgzYjlmYTllM2UxNzczODI1NCIsCiAgInByb2ZpbGVOYW1lIiA6ICJDVUNGTDE0IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzllNWY5OWJkMjhjNjQ5ZWEwOWI5ZWU2YTYxZjc5NWRiMDdiNzJiMmI0ZjliZGIyNGM0Nzk2NGY1M2VmODY3NSIKICAgIH0KICB9Cn0=").setCallback((x, y, z) -> {
            PagedGui.playClickSound(player);
            new ClaimAugmentGui(player, this, ClaimUtils.isInAdminMode((class_1657)player) || this.isOwner((class_1657)player), () -> this.openUi(player));
        }));
        if (this.type == GOMLBlocks.ADMIN_CLAIM_ANCHOR.getFirst()) {
            gui.addSlot((GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.admin_settings").method_27692(class_124.field_1068)).setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmY3YTQyMmRiMzVkMjhjZmI2N2U2YzE2MTVjZGFjNGQ3MzAwNzI0NzE4Nzc0MGJhODY1Mzg5OWE0NGI3YjUyMCJ9fX0=").setCallback((x, y, z) -> {
                PagedGui.playClickSound(player);
                new AdminAugmentGui(this, player, () -> this.openUi(player));
            }));
        }
        while (gui.getFirstEmptySlot() != -1) {
            gui.addSlot(PagedGui.DisplayElement.filler().element());
        }
        gui.open();
    }

    public ClaimAnchorBlock getType() {
        return this.type;
    }

    @ApiStatus.Internal
    public void internal_setIcon(class_1799 stack) {
        this.icon = stack.method_7972();
    }

    @ApiStatus.Internal
    public void internal_setType(ClaimAnchorBlock anchorBlock) {
        this.type = anchorBlock;
    }

    @ApiStatus.Internal
    public void internal_setWorld(class_2960 world) {
        this.world = world;
    }

    @ApiStatus.Internal
    public void internal_setClaimBox(ClaimBox box) {
        this.claimBox = box;
    }

    @ApiStatus.Internal
    public void internal_incrementChunks() {
        ++this.chunksLoadedCount;
    }

    @ApiStatus.Internal
    public void internal_decrementChunks() {
        --this.chunksLoadedCount;
        if (this.chunksLoadedCount == 0) {
            this.clearTickedPlayers();
        }
    }

    @ApiStatus.Internal
    public void internal_updateChunkCount(class_3218 world) {
        int minX = class_4076.method_18675((int)this.claimBox.toBox().x1());
        int minZ = class_4076.method_18675((int)this.claimBox.toBox().z1());
        int maxX = class_4076.method_18675((int)this.claimBox.toBox().x2());
        int maxZ = class_4076.method_18675((int)this.claimBox.toBox().z2());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!world.method_8393(x, z)) continue;
                ++this.chunksLoadedCount;
            }
        }
        if (this.chunksLoadedCount == 0) {
            this.clearTickedPlayers();
        }
    }

    private void clearTickedPlayers() {
        if (!this.previousTickPlayers.isEmpty()) {
            for (Augment augment : this.augments.values()) {
                if (augment == null) continue;
                for (class_1657 player : this.previousTickPlayers) {
                    augment.onPlayerExit(this, player);
                }
            }
        }
    }

    public void addAugment(class_2338 pos, Augment augment) {
        this.augments.put(pos, augment);
        for (class_1657 player : this.previousTickPlayers) {
            augment.onPlayerEnter(this, player);
        }
    }

    public void removeAugment(class_2338 pos) {
        Augment augment = this.augments.remove(pos);
        if (augment != null) {
            for (class_1657 player : this.previousTickPlayers) {
                augment.onPlayerExit(this, player);
            }
        }
    }

    public boolean hasAugment() {
        return this.augments.size() > 0;
    }

    public boolean hasAugment(Augment augment) {
        for (Augment a : this.augments.values()) {
            if (a != augment) continue;
            return true;
        }
        return false;
    }

    public Map<class_2338, Augment> getAugments() {
        return this.augments;
    }

    public ClaimBox getClaimBox() {
        return this.claimBox != null ? this.claimBox : ClaimBox.EMPTY;
    }

    public int getRadius() {
        return this.claimBox != null ? this.claimBox.radius() : 0;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public Collection<class_3222> getPlayersIn(MinecraftServer server) {
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.world));
        if (world == null) {
            return Collections.emptyList();
        }
        return world.method_8390(class_3222.class, this.getClaimBox().minecraftBox(), entity -> true);
    }

    public void tick(class_3218 world) {
        if (this.chunksLoadedCount > 0) {
            List playersInClaim = world.method_8390(class_1657.class, this.claimBox.minecraftBox(), entity -> true);
            for (Augment augment : this.augments.values()) {
                if (augment == null || !augment.isEnabled(this, (class_1937)world)) continue;
                if (augment.ticks()) {
                    augment.tick(this, (class_1937)world);
                    for (class_1657 playerEntity : playersInClaim) {
                        augment.playerTick(this, playerEntity);
                    }
                }
                for (class_1657 playerEntity : playersInClaim) {
                    if (this.previousTickPlayers.contains(playerEntity)) continue;
                    augment.onPlayerEnter(this, playerEntity);
                }
                this.previousTickPlayers.stream().filter(player -> !playersInClaim.contains(player)).forEach(player -> augment.onPlayerExit(this, (class_1657)player));
            }
            this.previousTickPlayers.clear();
            this.previousTickPlayers.addAll(playersInClaim);
        }
    }

    public Collection<PlayerGroup> getGroups() {
        Set<PlayerGroup> g = this.trustedGroups;
        if (g == null) {
            g = new HashSet<PlayerGroup>();
            Iterator<PlayerGroup.Key> iter = this.trustedGroupKeys.iterator();
            while (iter.hasNext()) {
                PlayerGroup.Key key = iter.next();
                PlayerGroup group = PlayerGroupProvider.getGroup(this.server, key);
                if (group == null) continue;
                g.add(group);
                iter.remove();
            }
            this.trustedGroups = g;
        }
        return g;
    }

    public void destroy() {
        for (PlayerGroup group : this.getGroups()) {
            group.removeClaim(this);
        }
        class_3218 world = this.getWorldInstance(this.server);
        if (world != null) {
            ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).remove(this);
        }
        if (!this.destroyed) {
            this.destroyed = true;
            ((ClaimEvents.GenericClaimEvent)ClaimEvents.CLAIM_DESTROYED.invoker()).onEvent(this);
            this.clearTickedPlayers();
        }
    }

    public boolean hasPermission(Collection<UUID> trusted) {
        for (UUID x : trusted) {
            if (!this.hasPermission(x)) continue;
            return true;
        }
        return false;
    }
}

