/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record DataKey<T>(class_2960 key, T defaultValue, Function<T, class_2520> serializer, Function<class_2520, T> deserializer, @Nullable Supplier<T> defaultSupplier) {
    private static final Map<class_2960, DataKey<?>> REGISTRY = new HashMap();

    public DataKey(class_2960 key, T defaultValue, Function<T, class_2520> serializer, Function<class_2520, T> deserializer) {
        this(key, defaultValue, serializer, deserializer, () -> defaultValue);
    }

    public DataKey(class_2960 key, T defaultValue, Function<T, class_2520> serializer, Function<class_2520, T> deserializer, @Nullable Supplier<T> defaultSupplier) {
        if (REGISTRY.containsKey(key)) {
            throw new RuntimeException("Duplicate key " + key + "! You can't register the same key twice!");
        }
        REGISTRY.put(key, this);
        this.key = key;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.defaultSupplier = defaultSupplier;
    }

    public static <T, C extends Collection<T>> DataKey<C> ofCollection(class_2960 key, Supplier<C> collectionCreator, Function<T, class_2520> serializer, Function<class_2520, T> deserializer) {
        return new DataKey<Collection>(key, (Collection)collectionCreator.get(), list -> {
            class_2499 nbt = new class_2499();
            for (Object i : list) {
                if (i == null) continue;
                nbt.add((Object)((class_2520)serializer.apply(i)));
            }
            return nbt;
        }, nbt -> {
            Collection list = (Collection)collectionCreator.get();
            if (nbt instanceof class_2483) {
                class_2483 nbtList = (class_2483)nbt;
                for (class_2520 i : nbtList) {
                    if (i == null) continue;
                    list.add(deserializer.apply(i));
                }
            }
            return list;
        }, collectionCreator);
    }

    public static DataKey<String> ofString(class_2960 key, String defaultValue) {
        return new DataKey<String>(key, defaultValue, s -> class_2519.method_23256((String)s), nbt -> {
            String string;
            if (nbt instanceof class_2519) {
                class_2519 nbtString = (class_2519)nbt;
                string = nbtString.method_10714();
            } else {
                string = defaultValue;
            }
            return string;
        });
    }

    public static DataKey<Boolean> ofBoolean(class_2960 key, boolean defaultValue) {
        return new DataKey<Boolean>(key, defaultValue, i -> class_2481.method_23234((boolean)i), nbt -> {
            class_2514 nbtNumber;
            return nbt instanceof class_2514 ? Boolean.valueOf((nbtNumber = (class_2514)nbt).method_10698() > 0) : Boolean.valueOf(defaultValue);
        });
    }

    public static DataKey<Integer> ofInt(class_2960 key, int defaultValue) {
        return new DataKey<Integer>(key, defaultValue, i -> class_2497.method_23247((int)i), nbt -> {
            Integer n;
            if (nbt instanceof class_2514) {
                class_2514 nbtNumber = (class_2514)nbt;
                n = nbtNumber.method_10701();
            } else {
                n = defaultValue;
            }
            return n;
        });
    }

    public static DataKey<UUID> ofUuid(class_2960 key) {
        return new DataKey<UUID>(key, class_156.field_25140, i -> class_2512.method_25929((UUID)i), nbt -> class_2512.method_25930((class_2520)nbt));
    }

    public static DataKey<Set<UUID>> ofUuidSet(class_2960 key) {
        return DataKey.ofCollection(key, HashSet::new, i -> class_2512.method_25929((UUID)i), nbt -> class_2512.method_25930((class_2520)nbt));
    }

    public static DataKey<Double> ofDouble(class_2960 key, double defaultValue) {
        return new DataKey<Double>(key, defaultValue, i -> class_2489.method_23241((double)i), nbt -> {
            Double d;
            if (nbt instanceof class_2514) {
                class_2514 nbtNumber = (class_2514)nbt;
                d = nbtNumber.method_10697();
            } else {
                d = defaultValue;
            }
            return d;
        });
    }

    public static DataKey<class_2338> ofPos(class_2960 key) {
        return new DataKey<class_2338>(key, null, i -> class_2512.method_10692((class_2338)i), nbt -> {
            class_2338 class_23382;
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                class_23382 = class_2512.method_10691((class_2487)compound);
            } else {
                class_23382 = null;
            }
            return class_23382;
        });
    }

    @Nullable
    public static DataKey<?> getKey(class_2960 key) {
        return REGISTRY.get(key);
    }

    public static Collection<class_2960> keys() {
        return REGISTRY.keySet();
    }

    public static <T extends Enum<T>> DataKey<T> ofEnum(class_2960 key, Class<T> tClass, T defaultValue) {
        return new DataKey<Enum>(key, defaultValue, i -> class_2519.method_23256((String)i.name()), nbt -> {
            Enum enum_;
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                enum_ = Enum.valueOf(tClass, string.method_10714());
            } else {
                enum_ = null;
            }
            Enum value = enum_;
            return value != null ? value : defaultValue;
        });
    }
}

