/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api;

import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class WorldParticleUtils {
    public static void render(class_3222 player, class_2338 min, class_2338 max, class_2394 effect) {
        Edge[] edges = WorldParticleUtils.edges(min, max);
        int maxInterval = 5;
        int maxCount = 40;
        for (Edge edge : edges) {
            int length = edge.length();
            double interval = 1.0;
            if (length > 0) {
                interval = class_3532.method_15340((int)(length / Math.min(maxCount, length)), (int)1, (int)maxInterval);
            }
            double steps = ((double)length + interval - 1.0) / interval;
            for (double i = 0.0; i < steps; i += 1.0) {
                double m = i * interval / (double)length;
                WorldParticleUtils.spawnParticleIfVisible(player, effect, edge.projX(m) + 0.5, edge.projY(m) + 0.5, edge.projZ(m) + 0.5);
            }
        }
    }

    private static void spawnParticleIfVisible(class_3222 player, class_2394 effect, double x, double y, double z) {
        class_3218 world = player.method_51469();
        class_243 delta = player.method_19538().method_1023(x, y, z);
        double length2 = delta.method_1027();
        if (length2 > 262144.0) {
            return;
        }
        world.method_14166(player, effect, true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static Edge[] edges(class_2338 min, class_2338 max) {
        ArrayList<Edge> list = new ArrayList<Edge>();
        int minX = min.method_10263();
        int minY = min.method_10264();
        int minZ = min.method_10260();
        int maxX = max.method_10263();
        int maxY = max.method_10264();
        int maxZ = max.method_10260();
        list.add(new Edge(minX, minY, minZ, minX, maxY, minZ));
        list.add(new Edge(maxX, minY, minZ, maxX, maxY, minZ));
        list.add(new Edge(minX, minY, maxZ, minX, maxY, maxZ));
        list.add(new Edge(maxX, minY, maxZ, maxX, maxY, maxZ));
        list.add(new Edge(minX, minY, minZ, maxX, minY, minZ));
        list.add(new Edge(minX, minY, maxZ, maxX, minY, maxZ));
        list.add(new Edge(maxX, minY, minZ, maxX, minY, maxZ));
        list.add(new Edge(minX, minY, minZ, minX, minY, maxZ));
        list.add(new Edge(minX, maxY, minZ, minX, maxY, maxZ));
        list.add(new Edge(maxX, maxY, minZ, maxX, maxY, maxZ));
        list.add(new Edge(minX, maxY, minZ, maxX, maxY, minZ));
        list.add(new Edge(minX, maxY, maxZ, maxX, maxY, maxZ));
        int height = max.method_10264() - min.method_10264();
        int count = class_3532.method_15384((double)((double)height / 64.0));
        int delta = height / count;
        for (int i = 1; i < count; ++i) {
            list.add(new Edge(minX, minY + i * delta, minZ, maxX, minY + i * delta, minZ));
            list.add(new Edge(minX, minY + i * delta, maxZ, maxX, minY + i * delta, maxZ));
            list.add(new Edge(maxX, minY + i * delta, minZ, maxX, minY + i * delta, maxZ));
            list.add(new Edge(minX, minY + i * delta, minZ, minX, minY + i * delta, maxZ));
        }
        return list.toArray(new Edge[0]);
    }

    private record Edge(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        double projX(double m) {
            return (double)this.startX + (double)(this.endX - this.startX) * m;
        }

        double projY(double m) {
            return (double)this.startY + (double)(this.endY - this.startY) * m;
        }

        double projZ(double m) {
            return (double)this.startZ + (double)(this.endZ - this.startZ) * m;
        }

        int length() {
            int dx = this.endX - this.startX;
            int dy = this.endY - this.startY;
            int dz = this.endZ - this.startZ;
            return class_3532.method_15384((double)Math.sqrt(dx * dx + dy * dy + dz * dz));
        }
    }
}

