/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.block.entity;

import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Selection;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.ClaimUtils;
import draylar.goml.registry.GOMLEntities;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class ClaimAugmentBlockEntity
extends class_2586
implements PolymerObject {
    private static final String PARENT_POSITION_KEY = "ParentPosition";
    private static final String CLAIM_POSITION_KEY = "ClaimPosition";
    private class_2338 parentPosition;
    private class_2338 claimPosition;
    private Augment augment;
    @Nullable
    private Claim claim;

    public ClaimAugmentBlockEntity(class_2338 pos, class_2680 state) {
        super(GOMLEntities.CLAIM_AUGMENT, pos, state);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T baseBlockEntity) {
        if (!(world instanceof class_3218)) return;
        if (!(baseBlockEntity instanceof ClaimAugmentBlockEntity)) return;
        ClaimAugmentBlockEntity entity = (ClaimAugmentBlockEntity)baseBlockEntity;
        if (entity.claim != null) {
            if (!entity.claim.isDestroyed()) return;
            world.method_22352(pos, true);
            return;
        }
        Selection<Entry<ClaimBox, Claim>> claims = null;
        if (entity.claimPosition != null) {
            claims = ClaimUtils.getClaimsWithOrigin((class_4538)world, entity.claimPosition);
        } else if (entity.parentPosition != null) {
            claims = ClaimUtils.getClaimsAt((class_4538)world, entity.parentPosition);
        }
        if (claims == null) {
            GetOffMyLawn.LOGGER.warn(String.format("An augment at %s has an invalid parent and parent position! Removing now.", entity.field_11867.toString()));
            world.method_22352(pos, true);
            return;
        }
        if (claims.isNotEmpty()) {
            entity.claim = (Claim)((Entry)((List)claims.collect(Collectors.toList())).get(0)).getValue();
            entity.claimPosition = entity.claim.getOrigin();
            entity.method_5431();
            return;
        }
        GetOffMyLawn.LOGGER.warn(String.format("An augment at %s tried to locate a parent at %s, but it could not be found!", entity.field_11867.toString(), entity.claimPosition.toString()));
        world.method_22352(pos, true);
    }

    protected void method_11007(class_2487 tag) {
        if (this.claimPosition != null) {
            tag.method_10544(CLAIM_POSITION_KEY, this.claimPosition.method_10063());
        }
        if (this.parentPosition != null) {
            tag.method_10544(PARENT_POSITION_KEY, this.parentPosition.method_10063());
        }
        super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10545(CLAIM_POSITION_KEY)) {
            this.claimPosition = class_2338.method_10092((long)tag.method_10537(CLAIM_POSITION_KEY));
        }
        this.parentPosition = class_2338.method_10092((long)tag.method_10537(PARENT_POSITION_KEY));
        if (this.augment == null && this.method_11010().method_26204() instanceof Augment) {
            this.initialize((Augment)this.method_11010().method_26204());
        }
        super.method_11014(tag);
    }

    public void remove() {
        if (this.claim != null) {
            this.claim.removeAugment(this.field_11867);
        }
    }

    public void setParent(class_2338 pos, Claim claim) {
        this.parentPosition = pos;
        this.claimPosition = claim.getOrigin();
        this.claim = claim;
        claim.addAugment(this.field_11867, this.getAugment());
    }

    public void initialize(Augment augment) {
        this.augment = augment;
    }

    public Augment getAugment() {
        Augment augment;
        if (this.augment != null) {
            return this.augment;
        }
        class_2248 class_22482 = this.method_11010().method_26204();
        return class_22482 instanceof Augment ? (augment = (Augment)class_22482) : Augment.noop();
    }

    @Nullable
    public Claim getClaim() {
        return this.claim;
    }
}

