/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.compat;

import draylar.goml.api.Claim;
import draylar.goml.api.group.PlayerGroup;
import draylar.goml.api.group.PlayerGroupProvider;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.fabric.events.GuildEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1768;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ArgonautsCompat {
    public static void init() {
        PlayerGroupProvider.register("argonauts_guild", GuildProvider.INSTANCE);
        GuildEvents.REMOVED.register((b, guild) -> {
            GuildGroup cached = GuildGroup.CACHE.get(guild);
            if (cached != null) {
                for (Claim claim : List.copyOf(cached.claims)) {
                    claim.untrust(cached);
                }
            }
            GuildGroup.CACHE.remove(guild);
        });
    }

    private record GuildProvider() implements PlayerGroupProvider
    {
        public static final PlayerGroupProvider INSTANCE = new GuildProvider();

        @Override
        @Nullable
        public PlayerGroup getGroupOf(class_1657 player) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Guild g = GuildApi.API.get(serverPlayer);
                return g != null ? GuildGroup.of(g) : null;
            }
            return null;
        }

        @Override
        @Nullable
        public PlayerGroup getGroupOf(MinecraftServer server, UUID uuid) {
            Guild g = GuildApi.API.getPlayerGuild(server, uuid);
            return g != null ? GuildGroup.of(g) : null;
        }

        @Override
        @Nullable
        public PlayerGroup fromKey(MinecraftServer server, PlayerGroup.Key key) {
            Guild guild = GuildApi.API.get(server, UUID.fromString(key.groupId()));
            return guild != null ? GuildGroup.of(guild) : null;
        }

        @Override
        public class_2561 getName() {
            return class_2561.method_43471((String)"text.goml.argonauts.guild_type.name");
        }
    }

    private record GuildGroup(Guild guild, HashSet<Claim> claims) implements PlayerGroup
    {
        private static WeakHashMap<Guild, GuildGroup> CACHE = new WeakHashMap();

        private GuildGroup(Guild guild) {
            this(guild, new HashSet<Claim>());
        }

        public static PlayerGroup of(Guild guild) {
            return CACHE.computeIfAbsent(guild, GuildGroup::new);
        }

        @Override
        public class_2561 selfDisplayName() {
            return this.guild.displayName();
        }

        @Override
        public class_2561 fullDisplayName() {
            return class_2561.method_43469((String)"text.goml.argonauts.guild_type.display", (Object[])new Object[]{class_2561.method_43473().method_10852(this.selfDisplayName()).method_27692(class_124.field_1068)});
        }

        @Override
        public PlayerGroup.Key getKey() {
            return new PlayerGroup.Key("argonauts_guild", this.guild.id().toString());
        }

        @Override
        public class_1799 icon() {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8577);
            Integer i = this.guild.color().method_532();
            ((class_1768)stack.method_7909()).method_7799(stack, i != null ? i : 0xFFFFFF);
            return stack;
        }

        @Override
        public PlayerGroupProvider provider() {
            return GuildProvider.INSTANCE;
        }

        @Override
        public boolean isPartOf(UUID uuid) {
            return this.guild.members().isMember(uuid);
        }

        @Override
        public boolean canSave() {
            return true;
        }

        @Override
        public List<PlayerGroup.Member> getMembers() {
            ArrayList<PlayerGroup.Member> list = new ArrayList<PlayerGroup.Member>();
            for (GuildMember x : this.guild.members().allMembers()) {
                PlayerGroup.Member member = new PlayerGroup.Member(x.profile(), x.getRole());
                list.add(member);
            }
            return list;
        }

        @Override
        public boolean addClaim(Claim claim) {
            return this.claims.add(claim);
        }

        @Override
        public boolean removeClaim(Claim claim) {
            return this.claims.remove(claim);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return this.guild.id().hashCode() + 31 * "argonauts".hashCode();
        }
    }
}

