/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.ui;

import com.mojang.authlib.GameProfile;
import draylar.goml.api.Claim;
import draylar.goml.api.group.PlayerGroup;
import draylar.goml.ui.GenericPlayerAndGroupSelectionGui;
import draylar.goml.ui.GenericPlayerListGui;
import draylar.goml.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClaimPlayerListGui
extends GenericPlayerListGui {
    private final Claim claim;
    private final boolean isAdmin;
    private final boolean canModifyOwners;
    private final boolean canModifyTrusted;
    private final List<PlayerGroup> groups = new ArrayList<PlayerGroup>();

    public ClaimPlayerListGui(class_3222 player, Claim claim, boolean canModifyTrusted, boolean canModifyOwners, boolean isAdmin, @Nullable Runnable onClose) {
        super(player, onClose);
        this.claim = claim;
        this.setTitle((class_2561)class_2561.method_43471((String)"text.goml.gui.player_list.title"));
        this.canModifyOwners = canModifyOwners;
        this.canModifyTrusted = canModifyTrusted;
        this.isAdmin = isAdmin;
        this.updateDisplay();
        this.open();
    }

    public static void open(class_3222 player, Claim claim, boolean admin, @Nullable Runnable onClose) {
        new ClaimPlayerListGui(player, claim, claim.isOwner((class_1657)player) || admin, admin, admin, onClose);
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        return id < this.groups.size() ? this.getGroupElement(id) : super.getElement(id - this.groups.size());
    }

    private PagedGui.DisplayElement getGroupElement(int id) {
        PlayerGroup group = this.groups.get(id);
        GuiElementBuilder builder = GuiElementBuilder.from((class_1799)group.icon()).setName((class_2561)class_2561.method_43473().method_10852(group.selfDisplayName()).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43473().method_10852(group.provider().getName()).method_10862(class_2583.field_24360.method_36139(4566015)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063))))).hideFlags();
        if (this.canModifyTrusted) {
            builder.addLoreLine((class_2561)class_2561.method_43471((String)"text.goml.gui.click_to_remove"));
            builder.setCallback((x, y, z) -> {
                ClaimPlayerListGui.playClickSound(this.player);
                this.claim.untrust(group);
                this.updateDisplay();
            });
        }
        return PagedGui.DisplayElement.of(builder);
    }

    @Override
    protected void updateDisplay() {
        this.groups.clear();
        this.groups.addAll(this.claim.getGroups());
        this.groups.sort(Comparator.comparing(x -> x.getKey().toString()));
        this.uuids.clear();
        this.uuids.addAll(this.claim.getOwners());
        this.uuids.addAll(this.claim.getTrusted());
        super.updateDisplay();
    }

    @Override
    protected PagedGui.DisplayElement getNavElement(int id) {
        return switch (id) {
            case 5 -> {
                if (this.canModifyTrusted) {
                    yield PagedGui.DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.player_list.add_player").method_27692(class_124.field_1060)).setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTY0MjM2Mzc1NDQxMCwKICAicHJvZmlsZUlkIiA6ICJkODAwZDI4MDlmNTE0ZjkxODk4YTU4MWYzODE0Yzc5OSIsCiAgInByb2ZpbGVOYW1lIiA6ICJ0aGVCTFJ4eCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS80OTQ0YTI5ZjY4Yzg4NmNmYWY2N2UxNTI1YmQyYWNjMmEzZDRlNDBjMDE3NzVjNzIyMTQwZjA4YjY5ZDVkNjliIiwKICAgICAgIm1ldGFkYXRhIiA6IHsKICAgICAgICAibW9kZWwiIDogInNsaW0iCiAgICAgIH0KICAgIH0KICB9Cn0=").setCallback((x, y, z) -> {
                        ClaimPlayerListGui.playClickSound(this.player);
                        this.ignoreCloseCallback = true;
                        this.close(true);
                        this.ignoreCloseCallback = false;
                        new GenericPlayerAndGroupSelectionGui(this.player, (class_2561)class_2561.method_43471((String)"text.goml.gui.player_add_gui.title"), p -> !this.claim.hasDirectPermission(p.getId()), p -> !this.claim.getGroups().contains(p), p -> this.claim.trust(p.getId()), this.claim::trust, this::refreshOpen).updateAndOpen();
                    }));
                }
                yield PagedGui.DisplayElement.filler();
            }
            default -> super.getNavElement(id);
        };
    }

    @Override
    protected void modifyBuilder(GuiElementBuilder builder, Optional<GameProfile> optional, UUID uuid) {
        boolean exist = optional.isPresent();
        GameProfile gameProfile = exist ? optional.get() : null;
        boolean isOwner = this.claim.isOwner(uuid);
        boolean canRemove = isOwner ? this.canModifyOwners : this.canModifyTrusted;
        builder.setName((class_2561)class_2561.method_43470((String)(exist ? gameProfile.getName() : uuid.toString())).method_27692(isOwner ? class_124.field_1065 : class_124.field_1068).method_10852((class_2561)(isOwner ? class_2561.method_43470((String)" (").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43471((String)"text.goml.owner").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)) : class_2561.method_43473())));
        if (canRemove) {
            builder.addLoreLine((class_2561)class_2561.method_43471((String)"text.goml.gui.click_to_remove"));
            builder.setCallback((x, y, z) -> {
                ClaimPlayerListGui.playClickSound(this.player);
                (isOwner ? this.claim.getOwners() : this.claim.getTrusted()).remove(uuid);
                this.updateDisplay();
            });
        }
    }
}

