/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.ui;

import com.mojang.authlib.GameProfile;
import draylar.goml.api.group.PlayerGroup;
import draylar.goml.api.group.PlayerGroupProvider;
import draylar.goml.ui.NamePlayerSelectorGui;
import draylar.goml.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class GenericPlayerSelectionGui
extends PagedGui {
    private final class_3324 playerManager;
    private final Predicate<GameProfile> shouldDisplay;
    private final Consumer<GameProfile> onClick;
    private int ticker;
    private List<GameProfile> cachedPlayers = Collections.emptyList();

    public GenericPlayerSelectionGui(class_3222 player, class_2561 title, Predicate<GameProfile> shouldDisplay, Consumer<GameProfile> onClick, Runnable postClose) {
        super(player, postClose);
        this.shouldDisplay = shouldDisplay;
        this.onClick = onClick;
        this.playerManager = Objects.requireNonNull(player.method_5682()).method_3760();
        this.setTitle(title);
    }

    public void updateAndOpen() {
        this.updateDisplay();
        this.open();
    }

    @Override
    protected int getPageAmount() {
        return this.getContentAmount() / 36;
    }

    protected int getContentAmount() {
        return this.cachedPlayers.size();
    }

    @Override
    protected void updateDisplay() {
        ArrayList<GameProfile> list = new ArrayList<GameProfile>();
        for (class_3222 p : this.playerManager.method_14571()) {
            if (!this.shouldDisplay.test(p.method_7334())) continue;
            list.add(p.method_7334());
        }
        for (PlayerGroup group : PlayerGroupProvider.getAllGroups(this.player)) {
            for (PlayerGroup.Member member : group.getMembers()) {
                if (list.contains(member.profile()) || !this.shouldDisplay.test(member.profile())) continue;
                list.add(member.profile());
            }
        }
        list.sort(Comparator.comparing(player -> player.getName()));
        this.cachedPlayers = list;
        super.updateDisplay();
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        return this.getPlayerElement(id);
    }

    protected PagedGui.DisplayElement getPlayerElement(int id) {
        if (this.cachedPlayers.size() > id) {
            GameProfile player = this.cachedPlayers.get(id);
            GuiElementBuilder b = new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43470((String)player.getName())).setSkullOwner(player, null).setCallback((x, y, z) -> {
                GenericPlayerSelectionGui.playClickSound(this.player);
                this.onClick.accept(player);
                this.close(this.closeCallback != null);
            });
            Collection<PlayerGroup> x2 = PlayerGroupProvider.getShared(this.player, player.getId());
            if (!x2.isEmpty()) {
                b.addLoreLine((class_2561)class_2561.method_43471((String)"text.goml.gui.shared_groups").method_27692(class_124.field_1065));
                for (PlayerGroup g : x2) {
                    b.addLoreLine((class_2561)class_2561.method_43470((String)"- ").method_10852(g.fullDisplayName()).method_27692(class_124.field_1080));
                }
            }
            return PagedGui.DisplayElement.of(b);
        }
        return PagedGui.DisplayElement.empty();
    }

    @Override
    protected PagedGui.DisplayElement getNavElement(int id) {
        return switch (id) {
            case 5 -> PagedGui.DisplayElement.of(new GuiElementBuilder(class_1802.field_8448).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.player_selector.by_name").method_27692(class_124.field_1060)).setCallback((x, y, z) -> {
                GenericPlayerSelectionGui.playClickSound(this.player);
                this.ignoreCloseCallback = true;
                this.close(true);
                this.ignoreCloseCallback = false;
                new NamePlayerSelectorGui(this.player, this.shouldDisplay, this::refreshOpen, p -> {
                    this.onClick.accept((GameProfile)p);
                    this.close(true);
                    if (this.closeCallback != null) {
                        this.closeCallback.run();
                    }
                });
            }));
            default -> super.getNavElement(id);
        };
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker == 20) {
            this.ticker = 0;
            this.updateDisplay();
        }
        super.onTick();
    }
}

