/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.compatibility;

import io.github.jamalam360.jamlib.JamLib;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public class JamLibCompatibilityModuleHandler {
    public static void initialize(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        if (mod.isEmpty()) {
            JamLib.LOGGER.warn("Attempted to initialize compatibility modules for non-existent mod " + modId);
            return;
        }
        if (!((ModContainer)mod.get()).getMetadata().containsCustomValue("jamlib:compatibility_modules")) {
            JamLib.LOGGER.warn("Attempted to initialize compatibility modules for mod with incorrect metadata", modId);
        }
        ((ModContainer)mod.get()).getMetadata().getCustomValue("jamlib:compatibility_modules").getAsObject().forEach(e -> {
            String compatId = (String)e.getKey();
            VersionPredicate versionPredicate = null;
            if (compatId.contains("[") && compatId.endsWith("]")) {
                String version = compatId.substring(compatId.indexOf("[") + 1, compatId.length() - 1);
                compatId = compatId.substring(0, compatId.indexOf("["));
                try {
                    versionPredicate = VersionPredicate.parse((String)version);
                }
                catch (VersionParsingException ex) {
                    JamLib.LOGGER.warn("Encountered invalid version range", version, "from compatibility modules of mod", modId);
                }
            }
            if (FabricLoader.getInstance().isModLoaded(compatId) && (versionPredicate == null || versionPredicate.test((Object)((ModContainer)FabricLoader.getInstance().getModContainer(compatId).get()).getMetadata().getVersion()))) {
                JamLib.LOGGER.info("Initializing", modId, "compatibility module for", compatId);
                try {
                    Class<?> clazz = Class.forName(((CustomValue)e.getValue()).getAsString());
                    ModInitializer init = (ModInitializer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    init.onInitialize();
                }
                catch (Exception exception) {
                    JamLib.LOGGER.warn("Failed to initialize compatibility module:", exception.toString());
                }
            }
        });
    }
}

