/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.chassis;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ChassisRangeDisplay {
    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;
    static Map<class_2338, Entry> entries = new HashMap<class_2338, Entry>();
    static List<GroupEntry> groupEntries = new ArrayList<GroupEntry>();

    public static void tick() {
        GroupEntry existingGroupForPos;
        class_746 player = class_310.method_1551().field_1724;
        class_638 world = class_310.method_1551().field_1687;
        boolean hasWrench = AllItems.WRENCH.isIn(player.method_6047());
        Iterator<Object> iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            class_2338 pos = iterator.next();
            Entry entry = entries.get(pos);
            if (ChassisRangeDisplay.tickEntry(entry, hasWrench)) {
                iterator.remove();
            }
            CreateClient.OUTLINER.keep(entry.getOutlineKey());
        }
        iterator = groupEntries.iterator();
        while (iterator.hasNext()) {
            GroupEntry group = (GroupEntry)iterator.next();
            if (ChassisRangeDisplay.tickEntry(group, hasWrench)) {
                iterator.remove();
                if (group == lastHoveredGroup) {
                    lastHoveredGroup = null;
                }
            }
            CreateClient.OUTLINER.keep(group.getOutlineKey());
        }
        if (!hasWrench) {
            return;
        }
        class_239 over = class_310.method_1551().field_1765;
        if (!(over instanceof class_3965)) {
            return;
        }
        class_3965 ray = (class_3965)over;
        class_2338 pos = ray.method_17777();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null || blockEntity.method_11015()) {
            return;
        }
        if (!(blockEntity instanceof ChassisBlockEntity)) {
            return;
        }
        boolean ctrl = AllKeys.ctrlDown();
        ChassisBlockEntity chassisBlockEntity = (ChassisBlockEntity)blockEntity;
        if (ctrl && (existingGroupForPos = ChassisRangeDisplay.getExistingGroupForPos(pos)) != null) {
            for (ChassisBlockEntity included : existingGroupForPos.includedBEs) {
                entries.remove(included.method_11016());
            }
            existingGroupForPos.timer = 200;
            return;
        }
        if (!entries.containsKey(pos) || ctrl) {
            ChassisRangeDisplay.display(chassisBlockEntity);
        } else if (!ctrl) {
            ChassisRangeDisplay.entries.get((Object)pos).timer = 200;
        }
    }

    private static boolean tickEntry(Entry entry, boolean hasWrench) {
        ChassisBlockEntity chassisBlockEntity = entry.be;
        class_1937 beWorld = chassisBlockEntity.method_10997();
        class_638 world = class_310.method_1551().field_1687;
        if (chassisBlockEntity.method_11015() || beWorld == null || beWorld != world || !world.method_8477(chassisBlockEntity.method_11016())) {
            return true;
        }
        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }
        --entry.timer;
        return entry.timer == 0;
    }

    public static void display(ChassisBlockEntity chassis) {
        if (AllKeys.ctrlDown()) {
            GroupEntry hoveredGroup = new GroupEntry(chassis);
            for (ChassisBlockEntity included : hoveredGroup.includedBEs) {
                CreateClient.OUTLINER.remove(Pair.of((Object)included.method_11016(), (Object)1));
            }
            groupEntries.forEach(entry -> CreateClient.OUTLINER.remove(entry.getOutlineKey()));
            groupEntries.clear();
            entries.clear();
            groupEntries.add(hoveredGroup);
            return;
        }
        class_2338 pos = chassis.method_11016();
        GroupEntry entry2 = ChassisRangeDisplay.getExistingGroupForPos(pos);
        if (entry2 != null) {
            CreateClient.OUTLINER.remove(entry2.getOutlineKey());
        }
        groupEntries.clear();
        entries.clear();
        entries.put(pos, new Entry(chassis));
    }

    private static GroupEntry getExistingGroupForPos(class_2338 pos) {
        for (GroupEntry groupEntry : groupEntries) {
            for (ChassisBlockEntity chassis : groupEntry.includedBEs) {
                if (!pos.equals((Object)chassis.method_11016())) continue;
                return groupEntry;
            }
        }
        return null;
    }

    private static class Entry {
        ChassisBlockEntity be;
        int timer;

        public Entry(ChassisBlockEntity be) {
            this.be = be;
            this.timer = 200;
            CreateClient.OUTLINER.showCluster(this.getOutlineKey(), this.createSelection(be)).colored(0xFFFFFF).disableLineNormals().lineWidth(0.0625f).withFaceTexture(AllSpecialTextures.HIGHLIGHT_CHECKERED);
        }

        protected Object getOutlineKey() {
            return Pair.of((Object)this.be.method_11016(), (Object)1);
        }

        protected Set<class_2338> createSelection(ChassisBlockEntity chassis) {
            HashSet<class_2338> positions = new HashSet<class_2338>();
            List<class_2338> includedBlockPositions = chassis.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null) {
                return Collections.emptySet();
            }
            positions.addAll(includedBlockPositions);
            return positions;
        }
    }

    private static class GroupEntry
    extends Entry {
        List<ChassisBlockEntity> includedBEs;

        public GroupEntry(ChassisBlockEntity be) {
            super(be);
        }

        @Override
        protected Object getOutlineKey() {
            return this;
        }

        @Override
        protected Set<class_2338> createSelection(ChassisBlockEntity chassis) {
            HashSet<class_2338> list = new HashSet<class_2338>();
            this.includedBEs = this.be.collectChassisGroup();
            if (this.includedBEs == null) {
                return list;
            }
            for (ChassisBlockEntity chassisBlockEntity : this.includedBEs) {
                list.addAll(super.createSelection(chassisBlockEntity));
            }
            return list;
        }
    }
}

