/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import net.minecraft.class_7923;

public class PonderIndexScreen
extends NavigatableSimiScreen {
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.3;
    protected class_768 chapterArea;
    protected final List<class_1792> items;
    private final double itemXmult = 0.5;
    private double itemYmult = 0.75;
    protected class_768 itemArea;
    private class_1799 hoveredItem = class_1799.field_8037;

    public PonderIndexScreen() {
        this.chapters = new ArrayList<PonderChapter>();
        this.items = new ArrayList<class_1792>();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.chapters.clear();
        this.items.clear();
        PonderRegistry.ALL.keySet().stream().map(key -> class_7923.field_41178.method_17966(key).or(() -> class_7923.field_41175.method_17966(key).map(class_2248::method_8389)).orElse(null)).filter(Objects::nonNull).filter(PonderIndexScreen::exclusions).forEach(this.items::add);
        boolean hasChapters = !this.chapters.isEmpty();
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.chapters.size(), class_3532.method_15340((int)((int)Math.ceil((float)this.chapters.size() / 4.0f)), (int)1, (int)4), 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.field_22789 * 0.5);
        int chapterCenterY = (int)((double)this.field_22790 * 0.3);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.method_37063(label);
            layout.next();
        }
        if (!hasChapters) {
            this.itemYmult = 0.5;
        }
        int maxItemRows = hasChapters ? 4 : 7;
        layout = LayoutHelper.centeredHorizontal(this.items.size(), class_3532.method_15340((int)((int)Math.ceil((float)this.items.size() / 11.0f)), (int)1, (int)maxItemRows), 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_22789 * 0.5);
        int itemCenterY = (int)((double)this.field_22790 * this.itemYmult);
        for (class_1792 item : this.items) {
            PonderButton b = (PonderButton)((AbstractSimiWidget)new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new class_1799((class_1935)item))).withCallback((x, y) -> {
                if (!PonderRegistry.ALL.containsKey(RegisteredObjects.getKeyOrThrow(item))) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new class_1799((class_1935)item)));
            });
            this.method_37063(b);
            layout.next();
        }
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(AllItems.WRENCH.asStack());
    }

    private static boolean exclusions(class_1792 item) {
        class_2248 block;
        return !(item instanceof class_1747) || !((block = ((class_1747)item).method_7711()) instanceof ValveHandleBlock) || AllBlocks.COPPER_VALVE_HANDLE.is(item);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++PonderUI.ponderTicks;
        this.hoveredItem = class_1799.field_8037;
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        for (class_364 child : this.method_25396()) {
            PonderButton button;
            if (!(child instanceof PonderButton) || !(button = (PonderButton)child).method_25405(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = (int)((double)this.field_22789 * 0.5);
        int y = (int)((double)this.field_22790 * 0.3);
        class_4587 ms = graphics.method_51448();
        if (!this.chapters.isEmpty()) {
            ms.method_22903();
            ms.method_46416((float)x, (float)y, 0.0f);
            UIRenderHelper.streak(graphics, 0.0f, this.chapterArea.method_3321() - 10, this.chapterArea.method_3322() - 20, 20, 220);
            graphics.method_51433(this.field_22793, "Topics to Ponder about", this.chapterArea.method_3321() - 5, this.chapterArea.method_3322() - 25, Theme.i(Theme.Key.TEXT), false);
            ms.method_22909();
        }
        x = (int)((double)this.field_22789 * 0.5);
        y = (int)((double)this.field_22790 * this.itemYmult);
        ms.method_22903();
        ms.method_46416((float)x, (float)y, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, this.itemArea.method_3321() - 10, this.itemArea.method_3322() - 20, 20, 220);
        graphics.method_51433(this.field_22793, "Items to inspect", this.itemArea.method_3321() - 5, this.itemArea.method_3322() - 25, Theme.i(Theme.Key.TEXT), false);
        ms.method_22909();
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.method_7960()) {
            return;
        }
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(0.0f, 0.0f, 200.0f);
        graphics.method_51446(this.field_22793, this.hoveredItem, mouseX, mouseY);
        ms.method_22909();
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean method_25421() {
        return true;
    }
}

