/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.IConductorHoldingFakePlayer;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockCheckableNavigation;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain;
import com.railwayteam.railways.mixin_interfaces.ICarriageBufferDistanceTracker;
import com.railwayteam.railways.mixin_interfaces.IDistanceTravelled;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.BlockPosUtils;
import com.railwayteam.railways.util.MixinVariables;
import com.railwayteam.railways.util.packet.SwitchDataUpdatePacket;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarriageContraptionEntity.class}, remap=false)
public abstract class MixinCarriageContraptionEntity
extends OrientedContraptionEntity
implements IDistanceTravelled {
    @Shadow
    private Carriage carriage;
    @Unique
    private boolean railways$fakePlayer = false;
    @Unique
    private double railways$distanceTravelled;
    @Unique
    boolean railways$switchMessage = false;

    private MixinCarriageContraptionEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"control"}, at={@At(value="HEAD")})
    private void recordFakePlayer(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (player.method_7334() == ConductorEntity.FAKE_PLAYER_PROFILE) {
            this.railways$fakePlayer = true;
        }
    }

    @WrapOperation(method={"control"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;closerThan(Lnet/minecraft/core/Position;D)Z", remap=true)})
    private boolean railways$closerThan(class_243 instance, class_2374 pos, double distance, Operation<Boolean> original) {
        if (this.railways$fakePlayer) {
            this.railways$fakePlayer = false;
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, pos, distance});
    }

    @WrapOperation(method={"control"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;throttle:D", opcode=180)})
    private double conductorSpeedControl(Train instance, Operation<Double> original, class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player) {
        IConductorHoldingFakePlayer conductorHolder;
        if (player instanceof IConductorHoldingFakePlayer && (conductorHolder = (IConductorHoldingFakePlayer)player).getConductor() != null) {
            return (double)conductorHolder.getConductor().getForwardSignalStrength() / 15.0;
        }
        return (Double)original.call(new Object[]{instance});
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;maxSpeed()F")})
    private void showSwitchOverlay(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        Optional targetState;
        Navigation nav = this.carriage.train.navigation;
        class_3499.class_3501 info = (class_3499.class_3501)this.contraption.getBlocks().get(controlsLocalPos);
        class_2350 initialOrientation = this.getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.comp_1342().method_28498((class_2769)ControlsBlock.field_11177)) {
            inverted = !((class_2350)info.comp_1342().method_11654((class_2769)ControlsBlock.field_11177)).equals((Object)initialOrientation);
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        if (inverted) {
            targetSpeed *= -1;
        }
        boolean spaceDown = heldControls.contains(4);
        double directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
        MixinVariables.temporarilySkipSwitches = true;
        boolean forward = !this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted);
        Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> lookAheadData = ((IGenerallySearchableNavigation)nav).railways$findNearestApproachableSwitch(forward);
        MixinVariables.temporarilySkipSwitches = false;
        TrackSwitch lookAhead = lookAheadData == null ? null : (TrackSwitch)((Object)lookAheadData.getFirst());
        boolean headOn = lookAheadData != null && (Boolean)((Pair)lookAheadData.getSecond()).getFirst() != false;
        Optional optional = targetState = lookAheadData == null ? Optional.empty() : (Optional)((Pair)lookAheadData.getSecond()).getSecond();
        if (lookAhead != null) {
            if (((Boolean)CRConfigs.server().flipDistantSwitches.get()).booleanValue() && spaceDown && lookAhead.isAutomatic() && !lookAhead.isLocked() && !this.carriage.train.navigation.isActive()) {
                if (headOn) {
                    lookAhead.trySetSwitchState(TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward));
                } else {
                    targetState.ifPresent(lookAhead::trySetSwitchState);
                }
            }
            boolean wrong = headOn ? TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward) != lookAhead.getSwitchState() : targetState.isPresent() && lookAhead.getSwitchState() != targetState.get();
            this.displayApproachSwitchMessage(player, lookAhead, wrong);
        } else {
            this.cleanUpApproachSwitchMessage(player);
        }
    }

    @Inject(method={"control"}, at={@At(value="TAIL")})
    private void railways$handcarHungerDepletion(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (((IHandcarTrain)this.carriage.train).railways$isHandcar() && !player.method_5998(class_1268.field_5808).method_31574((class_1792)AllItems.EXTENDO_GRIP.get())) {
            player.method_7322((float)this.carriage.train.speed * CRConfigs.server().handcarHungerMultiplier.getF());
        }
    }

    @Unique
    private void displayApproachSwitchMessage(class_1657 player, TrackSwitch sw, boolean isWrong) {
        this.sendSwitchInfo(player, sw.getSwitchState(), sw.isAutomatic(), isWrong, sw.isLocked());
        this.railways$switchMessage = true;
    }

    @Unique
    private void cleanUpApproachSwitchMessage(class_1657 player) {
        if (!this.railways$switchMessage) {
            return;
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)SwitchDataUpdatePacket.clear());
        }
        this.railways$switchMessage = false;
    }

    @Unique
    private void sendSwitchInfo(class_1657 player, TrackSwitchBlock.SwitchState state, boolean automatic, boolean isWrong, boolean isLocked) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)new SwitchDataUpdatePacket(state, automatic, isWrong, isLocked));
        }
    }

    @Inject(method={"updateTrackGraph"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;graph:Lcom/simibubi/create/content/trains/graph/TrackGraph;", opcode=3, ordinal=0)}, cancellable=true)
    private void cancelDerailing(CallbackInfo ci) {
        if (((Boolean)CRConfigs.client().skipClientDerailing.get()).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"tickContraption"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/CarriageContraptionEntity;tickActors()V")})
    private void setupBufferDistanceData(CallbackInfo ci) {
        int leadingDistance;
        ICarriageBufferDistanceTracker distanceTracker = (ICarriageBufferDistanceTracker)this.carriage;
        if (this.field_6002.field_9236) {
            return;
        }
        if (distanceTracker.railways$getLeadingDistance() != null && distanceTracker.railways$getTrailingDistance() != null) {
            return;
        }
        class_2338 leadingBogeyPos = null;
        class_2338 trailingBogeyPos = null;
        CarriageContraption cc = (CarriageContraption)this.contraption;
        class_2338 maxPos = new class_2338(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        class_2338 minPos = new class_2338(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (Map.Entry info : this.contraption.getBlocks().entrySet()) {
            minPos = BlockPosUtils.min(minPos, (class_2338)info.getKey());
            maxPos = BlockPosUtils.max(maxPos, (class_2338)info.getKey());
            if (!(((class_3499.class_3501)info.getValue()).comp_1342.method_26204() instanceof AbstractBogeyBlock)) continue;
            if (leadingBogeyPos == null) {
                leadingBogeyPos = (class_2338)info.getKey();
                continue;
            }
            if (trailingBogeyPos != null) continue;
            if (BlockPosUtils.normalize(((class_2338)info.getKey()).method_10059((class_2382)leadingBogeyPos)).equals((Object)cc.getAssemblyDirection().method_10163())) {
                trailingBogeyPos = (class_2338)info.getKey();
                continue;
            }
            trailingBogeyPos = leadingBogeyPos;
            leadingBogeyPos = (class_2338)info.getKey();
        }
        class_2350.class_2351 axis = cc.getAssemblyDirection().method_10166();
        boolean forward = cc.getAssemblyDirection().method_10171() == class_2350.class_2352.field_11056;
        int leadingBounds = forward ? minPos.method_30558(axis) : maxPos.method_30558(axis);
        int trailingBounds = forward ? maxPos.method_30558(axis) : minPos.method_30558(axis);
        int n = leadingDistance = leadingBogeyPos == null ? 0 : Math.abs(leadingBounds - leadingBogeyPos.method_30558(axis));
        if (trailingBogeyPos == null) {
            trailingBogeyPos = leadingBogeyPos;
        }
        int trailingDistance = trailingBogeyPos == null ? 0 : Math.abs(trailingBounds - trailingBogeyPos.method_30558(axis));
        distanceTracker.railways$setLeadingDistance(leadingDistance);
        distanceTracker.railways$setTrailingDistance(trailingDistance);
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;getCurrentStation()Lcom/simibubi/create/content/trains/station/GlobalStation;")})
    private void noBufferOverrun(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir, @Local(name={"targetSpeed"}) LocalIntRef targetSpeedRef) {
        double blockedSign;
        double targetSpeed = targetSpeedRef.get();
        if (targetSpeed == 0.0) {
            return;
        }
        IBufferBlockedTrain bufferBlockedTrain = (IBufferBlockedTrain)this.carriage.train;
        if (!bufferBlockedTrain.railways$isControlBlocked() && bufferBlockedTrain.railways$getBlockedSign() == 0 && targetSpeed < 0.0) {
            ((IBufferBlockCheckableNavigation)this.carriage.train.navigation).railways$updateControlsBlock(true);
        }
        if (bufferBlockedTrain.railways$isControlBlocked() && ((blockedSign = (double)bufferBlockedTrain.railways$getBlockedSign()) == 0.0 && targetSpeed > 0.0 || blockedSign == (double)class_3532.method_17822((double)targetSpeed))) {
            targetSpeedRef.set(0);
        }
    }

    @Inject(method={"tickContraption"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/utility/Couple;getFirst()Ljava/lang/Object;")})
    private void railways$storeDistanceTravelled(CallbackInfo ci, @Local(name={"distanceTo"}, ordinal=0) double distanceTo) {
        this.railways$distanceTravelled = distanceTo;
    }

    @Override
    public double railways$getDistanceTravelled() {
        return this.railways$distanceTravelled;
    }
}

